//								EJEMPLO 25
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//El TMR1 en el modo contador. Frecuencmetro
//
//Mediante el generador de onda cuadrada del laboratorio, se aplican pulsos por la 
//lnea RC0/T1CKI. 
//
//El TMR1 cuenta los pulsos durante un intervalo de 1s. Al resultado de la cuenta  representa
//el nmero de pulsos por segundo o herzios.
//
//Dicha frecuencia se visualiza por la pantalla LCD

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use fast_io (A)
#use fast_io (B)
#use fast_io (C)
#use delay(clock=4000000)
#include<lcd2.c>		//Incluye funciones de control del LCD

main()
{  
	SETUP_ADC_PORTS(NO_ANALOGS);//Puerta A Digital
	output_b(0x00);		//Borra salidas
	set_tris_b(0x00);	//Puerta B salida
	set_tris_c(0xff);	//Puerta C entrada	
	lcd_init();			//Inica la pantalla LCD	
	setup_timer_1(T1_EXTERNAL | T1_DIV_BY_1);	//TMR1 como contador externo de eventos

	while(1)
	{	
	set_timer1(0);		//Puesta a 0 del TMR1
	setup_timer_1(T1_EXTERNAL | T1_DIV_BY_1);	//TMR1 como contador externo de eventos
	delay_ms(1000);		//Temporiza 1 seg.
	setup_timer_1(t1_disabled);	//Detiene la cuenta
	lcd_enviar(LCD_COMANDO,LCD_HOME);	//Coloca el cursor del LCD
	printf(lcd_putc,"%05Lu",get_timer1());	//Lee TMR1 y visualiza
	}
}	
